<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 3.7.0 Beta 5 - Licence Number DGT-SERIAL
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2008 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/

if (!isset($GLOBALS['vbulletin']->db))
{
	exit;
}

/**
* Abstracted human verification class
*
* @package 		vBulletin
* @version		$Revision: 25433 $
* @date 		$Date: 2008-01-14 09:11:37 -0600 (Mon, 14 Jan 2008) $
*
*/
class vB_HumanVerify
{
	/**
	* Constructor
	* Does nothing :p
	*
	* @return	void
	*/
	function vB_HumanVerify() {}

	/**
	* Singleton emulation: Select library
	*
	* @return	object
	*/
	function &fetch_library(&$registry, $library = '')
	{
		global $show;
		static $instance;

		if (!$instance)
		{
			if ($library)
			{		// Override the defined vboption
					$chosenlib = $library;
			}
			else
			{
					$chosenlib = ($registry->options['hv_type'] ? $registry->options['hv_type'] : 'Disabled');
			}

			$selectclass = 'vB_HumanVerify_' . $chosenlib;
			$chosenlib = strtolower($chosenlib);
			require_once(DIR . '/includes/class_humanverify_' . $chosenlib . '.php');
			$instance = new $selectclass($registry);
		}

		return $instance;
	}
}

class vB_HumanVerify_Abstract
{
	/**
	* Main data registry
	*
	* @var	vB_Registry
	*/
	var $registry = null;

	/**
	* Error string
	*
	* @var	string
	*/
	var $error = '';

	/**
	* Last generated hash
	*
	* @var	string
	*/
	var $hash = '';

	/**
	* Constructor
	* Don't allow direct construction of this abstract class
	* Sets registry
	*
	* @return	void
	*/
	function vB_HumanVerify_Abstract(&$registry)
	{
		if (!is_subclass_of($this, 'vB_HumanVerify_Abstract'))
		{
			trigger_error('Direct Instantiation of vB_HumanVerify_Abstract prohibited.', E_USER_ERROR);
			return NULL;
		}

		$this->registry =& $registry;
	}

	function delete_token($hash, $answer = NULL, $viewed = NULL)
	{
		$options = array(
			"hash = '" . $this->registry->db->escape_string($hash) . "'"
		);

		if ($answer !== NULL)
		{
			$options[] = "answer = '" . $this->registry->db->escape_string($answer) . "'";
		}
		if ($viewed !== NULL)
		{
			$options[] = "viewed = " . intval($viewed);
		}

		if ($this->hash == $hash)
		{
			$this->hash = '';
		}

		$this->registry->db->query_write("
			DELETE FROM " . TABLE_PREFIX . "humanverify WHERE " . implode(" AND ", $options) . "
		");

		return $this->registry->db->affected_rows() ? true : false;
	}

	function output_token($var_prefix = 'humanverify') {}

	function generate_token($deletehash = true)
	{
		$verify = array(
			'hash'   => md5(uniqid(rand(), 1)),
			'answer' => $this->fetch_answer(),
		);

		if ($deletehash AND $this->hash)
		{
			$this->delete_token($this->hash);
		}
		$this->hash = $verify['hash'];

		$this->registry->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "humanverify
				(hash, answer, dateline)
			VALUES
				('" . $this->registry->db->escape_string($verify['hash']) . "', '" . $this->registry->db->escape_string($verify['answer']) . "', " . TIMENOW . ")"
		);

		return $verify;
	}

	function verify_token($input)
	{
		return true;
	}

	function fetch_error()
	{
		return $this->error;
	}

	function fetch_answer() {}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: DGT-DATE
|| # CVS: $RCSfile$ - $Revision: 25433 $
|| ####################################################################
\*======================================================================*/
?>